import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { queryResponse } from "../util/processResponse.js";

const initialState = {
    bestSellers: [],
    loading: true,
};

export const getbestSellers = createAsyncThunk(
    "items/getbestSellers",
    async (URL) => {
        const data = await queryResponse(URL, "GET");
        return data;
    }
);

const bestSellersSlice = createSlice({
    name: "items",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(getbestSellers.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getbestSellers.fulfilled, (state, { payload = {} }) => {
            state.bestSellers = payload?.records?.data;
            state.loading = false;
        });
        builder.addCase(getbestSellers.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default bestSellersSlice.reducer;
